/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.util.NBTJsonUtil;
import noppes.npcs.util.Util;

public class TempFile {
    private static final int maxPart = 30000;
    public String name;
    public final Map<Integer, String> data = new TreeMap<Integer, String>();
    public int fileType;
    public int saveType;
    public int tryLoads;
    public long size;
    public long lastLoad;

    public TempFile() {
        this.name = "";
        this.fileType = 0;
        this.saveType = 0;
        this.size = 0L;
        this.tryLoads = 0;
        this.lastLoad = System.currentTimeMillis();
    }

    public TempFile(String name, int filetype, int savetype, long size) {
        this.name = name;
        this.fileType = filetype;
        this.saveType = savetype;
        this.size = size;
        this.tryLoads = 0;
        this.lastLoad = System.currentTimeMillis();
    }

    public NBTTagCompound getDataNbt() {
        if (this.fileType == 0) {
            return null;
        }
        try {
            return NBTJsonUtil.Convert(this.getDataText());
        }
        catch (Exception e) {
            LogWriter.error(e);
            return null;
        }
    }

    public String getDataText() {
        StringBuilder text = new StringBuilder();
        for (String str : this.data.values()) {
            text.append(str);
        }
        return text.toString();
    }

    public int getNextPart() {
        if (this.data.isEmpty()) {
            return -1;
        }
        int i = 0;
        for (String str : this.data.values()) {
            if (str == null || str.isEmpty()) break;
            ++i;
        }
        return i;
    }

    public NBTTagCompound getTitle() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("name", this.name);
        nbt.func_74768_a("filetype", this.fileType);
        nbt.func_74768_a("savetype", this.saveType);
        nbt.func_74768_a("parts", this.data.size());
        nbt.func_74772_a("size", this.size);
        return nbt;
    }

    public boolean isLoad() {
        if (this.data.isEmpty()) {
            return false;
        }
        for (String str : this.data.values()) {
            if (str != null && !str.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void reset(File file) throws IOException {
        if (file == null || !file.exists()) {
            this.data.clear();
            this.size = -1L;
            return;
        }
        this.saveType = 0;
        this.size = file.length();
        try {
            NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0]));
            this.fileType = 2;
            this.reset(NBTJsonUtil.Convert(nbt));
            return;
        }
        catch (IOException e) {
            LogWriter.error(e);
            String text = Util.instance.loadFile(file);
            try {
                NBTJsonUtil.Convert(text);
                this.fileType = 1;
            }
            catch (Exception e2) {
                LogWriter.error(e2);
            }
            this.reset(text);
            return;
        }
    }

    public void reset(String text) {
        if (text == null || text.isEmpty()) {
            this.data.clear();
            this.size = -1L;
            return;
        }
        if (this.size < 0L) {
            this.size = text.getBytes().length;
        }
        int part = 0;
        while (!text.isEmpty()) {
            int end = Math.min(text.length(), 30000);
            this.data.put(part, text.substring(0, end));
            if (end == text.length()) break;
            text = text.substring(end);
            ++part;
        }
    }

    public void save() throws IOException {
        File dir;
        if (!this.isLoad()) {
            return;
        }
        File file = new File(this.name);
        if (this.saveType == 0) {
            File dir2 = new File(CustomNpcs.Dir, "temp files");
            if (dir2.exists() || dir2.mkdir()) {
                file = new File(dir2, file.getName());
            }
        } else if (this.saveType == 1 && ((dir = new File(CustomNpcs.Dir, "client scripts/ecmascript")).exists() || dir.mkdir())) {
            file = new File(dir, file.getName());
        }
        if (!file.exists() && !file.createNewFile()) {
            return;
        }
        if (file.exists()) {
            this.saveTo(file);
            return;
        }
        LogWriter.error("Unable to create file: " + file.getAbsolutePath() + ". Path is incorrect!");
    }

    private void saveTo(File file) {
        switch (this.fileType) {
            case 1: {
                try {
                    Util.instance.saveFile(file, NBTJsonUtil.Convert(this.getDataNbt()));
                    LogWriter.debug("Save nbt json to file: " + file.getAbsolutePath());
                }
                catch (Exception e) {
                    LogWriter.error("Error save nbt json to file: " + file.getAbsolutePath(), e);
                }
                break;
            }
            case 2: {
                try {
                    CompressedStreamTools.func_74799_a((NBTTagCompound)this.getDataNbt(), (OutputStream)Files.newOutputStream(file.toPath(), new OpenOption[0]));
                    LogWriter.debug("Save nbt compressed to file: " + file.getAbsolutePath());
                }
                catch (IOException e) {
                    LogWriter.error("Error save nbt compressed to file: " + file.getAbsolutePath(), e);
                }
                break;
            }
            default: {
                if (!Util.instance.saveFile(file, this.getDataText())) break;
                LogWriter.debug("Save text to file: " + file.getAbsolutePath());
            }
        }
    }

    public void setTitle(NBTTagCompound nbt) {
        this.name = nbt.func_74779_i("name");
        this.fileType = nbt.func_74762_e("filetype");
        this.saveType = nbt.func_74762_e("savetype");
        this.size = nbt.func_74763_f("size");
        this.data.clear();
        this.lastLoad = 0L;
        for (int i = 0; i < nbt.func_74762_e("parts"); ++i) {
            this.data.put(i, "");
        }
    }
}

